/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.mcinterface;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import minecrafttransportsimulator.baseclasses.Point3D;
import minecrafttransportsimulator.entities.components.AEntityA_Base;
import minecrafttransportsimulator.items.components.AItemPack;
import minecrafttransportsimulator.jsondefs.AJSONMultiModelProvider;
import minecrafttransportsimulator.mcinterface.IWrapperItemStack;
import minecrafttransportsimulator.packloading.PackParser;

public interface IWrapperNBT {
    public static boolean isDataEqual(IWrapperNBT data1, IWrapperNBT data2) {
        if (data1 == null) {
            return data2 == null;
        }
        if (data2 == null) {
            return data1 == null;
        }
        return data1.equals(data2);
    }

    default public void deleteAllUUIDTags() {
        this.deleteEntry(AEntityA_Base.UNIQUE_UUID_TAG_NAME);
        this.getAllNames().forEach(name -> {
            IWrapperNBT data2 = this.getData((String)name);
            if (data2 != null) {
                data2.deleteAllUUIDTags();
            }
        });
    }

    public boolean getBoolean(String var1);

    public void setBoolean(String var1, boolean var2);

    public int getInteger(String var1);

    public void setInteger(String var1, int var2);

    public double getDouble(String var1);

    public void setDouble(String var1, double var2);

    public String getString(String var1);

    public void setString(String var1, String var2);

    public List<String> getStrings(String var1);

    public List<String> getStrings(String var1, int var2);

    public void setStrings(String var1, Collection<String> var2);

    public UUID getUUID(String var1);

    public void setUUID(String var1, UUID var2);

    default public <ItemPackActual extends AItemPack<?>> ItemPackActual getPackItem() {
        return (ItemPackActual)PackParser.getItem(this.getString("packID"), this.getString("systemName"), this.getString("subName"));
    }

    default public void setPackItem(AJSONMultiModelProvider definition, String subName) {
        this.setString("packID", definition.packID);
        this.setString("systemName", definition.systemName);
        this.setString("subName", subName);
    }

    public List<IWrapperItemStack> getStacks(int var1);

    public void setStacks(List<IWrapperItemStack> var1);

    public Point3D getPoint3d(String var1);

    public void setPoint3d(String var1, Point3D var2);

    public List<Point3D> getPoint3ds(String var1);

    public void setPoint3ds(String var1, Collection<Point3D> var2);

    public Point3D getPoint3dCompact(String var1);

    public void setPoint3dCompact(String var1, Point3D var2);

    public List<Point3D> getPoint3dsCompact(String var1);

    public void setPoint3dsCompact(String var1, Collection<Point3D> var2);

    public IWrapperNBT getData(String var1);

    public void setData(String var1, IWrapperNBT var2);

    public boolean hasKey(String var1);

    public void deleteEntry(String var1);

    public Set<String> getAllNames();
}

